﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using System.Threading;

namespace C_sharp_Test_Code_JI_4040_Rev1
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }


        // Create new instance of the JI_4040_NET device class //
        JI_4040_NET JI4040_Device = new JI_4040_NET();

        //----------------------------------------------------------------//
        // Open USB Port and Initilize JI-4040
        // Return: True if successful
        //
        private bool USBopen_Init()
        {
            if (JI4040_Device.Open() != 0)
            {
                // Error: Open //
                return false;
            }
            else if(JI4040_Device.Init() != true)
            {
                // Error: Init //
                return false;
            }
            else
            {
                // Success: Open and Init //
                return true;
            }
        }
        //----------------------------------------------------------------//

        //----------------------------------------------------------------//
        // USB Open - Button click
        //
        private void openButton1_Click(object sender, EventArgs e)
        {
            if (USBopen_Init() == true)
            {
                statusTextBox1.Text = "Open";
            }
            else
            {
                statusTextBox1.Text = "Error: Open";
            }
        }
        //----------------------------------------------------------------//

        //----------------------------------------------------------------//
        // Set I/O Direction and Read/Write Port 8-bit Data
        // Return: True if successful
        //
        private bool setIODir_RWData()
        {
            const string DIR_INPUT = "00";
            const string DIR_OUTPUT = "ff";

            // Set Ports A, C, and E as Inputs //
            if (JI4040_Device.Write("DA" + DIR_INPUT) != true ||
                JI4040_Device.Write("DC" + DIR_INPUT) != true ||
                JI4040_Device.Write("DE" + DIR_INPUT) != true  )
            {
                // Error //
                return false;
            }
            // Set Ports B, D, and F as Outputs //
            if (JI4040_Device.Write("DB" + DIR_OUTPUT) != true ||
                JI4040_Device.Write("DD" + DIR_OUTPUT) != true ||
                JI4040_Device.Write("DF" + DIR_OUTPUT) != true)
            {
                // Error //
                return false;
            }

            string strPortA, strPortC, strPortE;

            // Read Ports A, C, and E //
            if (JI4040_Device.Read("RA", out strPortA) != true ||
                JI4040_Device.Read("RC", out strPortC) != true ||
                JI4040_Device.Read("RE", out strPortE) != true)
            {
                // Error //
                return false;
            }

            // Write data:
            //             Port A -> Port B
            //             Port C -> Port D
            //             Port E -> PortF
            if (JI4040_Device.Write("WB" + strPortA) != true ||
                JI4040_Device.Write("WD" + strPortC) != true ||
                JI4040_Device.Write("WF" + strPortE) != true)
            {
                // Error //
                return false;
            }
            
            return true;          
        }
        //----------------------------------------------------------------//

        //----------------------------------------------------------------//
        // R/W Port - 8-Bit Data - Button click
        //
        private void rwPortsButton_Click(object sender, EventArgs e)
        {
            if (setIODir_RWData() == true)
            {
                statusTextBox1.Text = "Success: R/W Port 8-bit";
            }
            else
            {
                statusTextBox1.Text = "Error: R/W Port 8-bit";
            }
        }
        //----------------------------------------------------------------//

        //----------------------------------------------------------------//
        // Set I/O Direction and Read/Write Port 32-bit Data
        // Return: True if successful
        //
        private bool setIODir_RWData32bit()
        {
            const string DIR_INPUT = "00";
            const string DIR_OUTPUT = "ff";

            // Set Ports A & C as Inputs //
            if (JI4040_Device.Write("DA" + DIR_INPUT) != true ||
                JI4040_Device.Write("DC" + DIR_INPUT) != true)
            {
                // Error //
                return false;
            }
            // Set Ports B & D as Outputs //
            if (JI4040_Device.Write("DB" + DIR_OUTPUT) != true ||
                JI4040_Device.Write("DD" + DIR_OUTPUT) != true )
            {
                // Error //
                return false;
            }

            string strPortABCD;

            // Read Ports A, B, C, and D //
            if (JI4040_Device.Read("ZZ", out strPortABCD) != true)
            {
                // Error //
                return false;
            }
            
            // Write data:
            //             Port A -> Port B
            //             Port C -> Port D
            if (JI4040_Device.Write("YY" + "00" + strPortABCD.Substring(0, 2) +
                "00" + strPortABCD.Substring(4, 2)) != true)
            {
                // Error //
                return false;
            }
            return true;
        }
        //----------------------------------------------------------------//

        //----------------------------------------------------------------//
        // R/W Port - 32-Bit Data - Button click
        //
        private void rwPorts32Button_Click(object sender, EventArgs e)
        {
            if (setIODir_RWData32bit() == true)
            {
                statusTextBox1.Text = "Success: R/W Port 32-bit";
            }
            else
            {
                statusTextBox1.Text = "Error: R/W Port 32-bit";
            }
        }
        //----------------------------------------------------------------//

        //----------------------------------------------------------------//
        // Configure Port G as a 10KHz, 50% duty cycle, Clock source
        // Return: True if successful
        //
        private bool setPortG_10KHz_CLK()
        {
             // Configure Ports G as a CLK source //
            if (JI4040_Device.Write("CG" + "20") != true)
            {
                // Error //
                return false;
            }
            
            // Set G Prescalar to divide-by 10. Resolution is 1 us (1MHz).  //
            if (JI4040_Device.Write("KG" + "09") != true)
            {
                // Error //
                return false;
            }

            // Set Port G TH = TL = 50.
            // Signal period = 100uS @ 50% duty cycle.  //
            if (JI4040_Device.Write("HG" + "0031") != true ||
                JI4040_Device.Write("NG" + "0031") != true )
            {
                // Error //
                return false;
            }

            // Start CLK //
            if (JI4040_Device.Write("GG") != true)
            {
                // Error //
                return false;
            }
                        
            return true;
        }
        //----------------------------------------------------------------//

        //----------------------------------------------------------------//
        // 10KHz CLK Source Port G - Button click
        //
        private void PortG_10KHzCLK_Button_Click(object sender, EventArgs e)
        {
            if (setPortG_10KHz_CLK() == true)
            {
                statusTextBox1.Text = "Success: 10KHz CLK Port G";
            }
            else
            {
                statusTextBox1.Text = "Error: 10KHz CLK Port G";
            }
        }
        //----------------------------------------------------------------//

        //----------------------------------------------------------------//
        // Configure Port H as a positive-edge pulse timer with a 1uS resolution
        // Return: True if successful
        //
        private bool configPortH_PosEdgePulseTimer()
        {
            // Configure Port H as a positive-edge pulse timer //
            if (JI4040_Device.Write("CH" + "32") != true)
            {
                // Error //
                statusTextBox1.Text = "Error: Port H Write!";
                return false;
            }

            // Set H Prescalar to divide-by 10. Resolution is 1 us (1MHz).  //
            if (JI4040_Device.Write("KH" + "09") != true)
            {
                // Error //
                statusTextBox1.Text = "Error: Port H Write!";
                return false;
            }
        
            return true;
        }
        //----------------------------------------------------------------//

        //----------------------------------------------------------------//
        // Configure Port H as a positive-edge pulse timer - Button click
        //
        private void configPortG_PTimerButton_Click(object sender, EventArgs e)
        {
            if (configPortH_PosEdgePulseTimer() == true)
            {
                statusTextBox1.Text = "Port G Pulse Timer configured";
            }
            else
            {
                // Error //
                statusTextBox1.Text = "Error: Port H Write!";
            } 
        }
        //----------------------------------------------------------------//

        //----------------------------------------------------------------//
        // Start Measurement Port H Pulse Timer - Button click
        //
        private void run_portG_PulseTimerButton_Click(object sender, EventArgs e)
        {
            // Send Start Command //
            if (JI4040_Device.Write("GH") != true)
            {
                // Error //
                statusTextBox1.Text = "Error: Port H Write!";
                return;
            }
            else
            {
                statusTextBox1.Text = "Measurement in Progress";
                this.Refresh();

                // Check for measurement done // 
                string statusStr;
                for (int i = 0; i < 200; ++i)
                {
                    // Sleep for 1 ms //
                    Thread.Sleep(1);
                    if(JI4040_Device.Read("UH", out statusStr) != true) 
                    {
                        // Error //
                        statusTextBox1.Text = "Error: Port H Read!";
                        return;
                    }
                    // Check Status:  Bit 2 = Pulse/Period Timer Overflow	1 = Overflow
                    //                Bit 1 = Pulse/Period Timer Data RDY	1 = Data ready
                    statusStr = statusStr.Substring(1, 1);
                    int j = Convert.ToByte(statusStr, 16);
                    j = j & 0x06;
                    
                    // Data Ready? //
                    if ((j & 0x02) > 0)
                    {   // Yes. Check for Overflow //
                        if ((j & 0x04) > 0)
                        {
                            statusTextBox1.Text = "Measurement Overflow!";
                            return;
                        }
                        else
                        {
                            // Read Timer Data //
                            string dataStr;
                            if (JI4040_Device.Read("JH", out dataStr) != true)
                            {
                                // Error //
                                statusTextBox1.Text = "Error: Port H Read!";
                                return;
                            }
                            j = Convert.ToUInt16(dataStr, 16);
                            // Print Measurement //
                            statusTextBox1.Text = "Pulse Width = " + j.ToString() + "uS";
                            return;
                        }
                    }
                }
                // Measurement Timeout //
                statusTextBox1.Text = "Measurement Time-out!";
                
                // Send Stop Command //
                if (JI4040_Device.Write("PH") != true)
                {
                    // Error //
                    statusTextBox1.Text = "Error: Port H Write! ";
                    return;
                }
 
            }
        }
        //----------------------------------------------------------------//
         
        //----------------------------------------------------------------//
        // About - Button click
        //
        private void aboutButton_Click(object sender, EventArgs e)
        {
            //Print HW Rev and VHDL Ver //

            string str1;
            if (JI4040_Device.Read("VV", out str1) != true)
            {
                // Error //
                statusTextBox1.Text = "Error: About Read!";
                return;
            }

            string HWchar = str1.Substring(0, 2);
            int i = Convert.ToUInt16(HWchar, 16);
            char c = (char)i;
            HWchar = c.ToString();

            string VHDLchar = str1.Substring(2, 2);
            i = Convert.ToUInt16(VHDLchar, 16);
            c = (char)i;
            VHDLchar = c.ToString(); 

            statusTextBox1.Text = "HW Rev: " + HWchar +
                               ", VHDL Ver: " + VHDLchar;
        }
        //----------------------------------------------------------------//

    }
}
//------------------------------------------------------------------------//