﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.Threading;
using FTD2XX_NET;

//----------------------------------------------------//
// 3/10/2011 Initial release                         
//----------------------------------------------------//
// 4/2/2011 
//         1. Several general modifications         
//         2. Clean-up comments                      
//---------------------------------------------------//

namespace JI_4040_Test_Application_4
{
    class JI_4040_NET
    {
        // Create new instance of the FTDI device class
        FTDI FTDIDevice = new FTDI();

        UInt32 FTDIDeviceCount = 0;
        FTDI.FT_STATUS ftStatus = FTDI.FT_STATUS.FT_OK;



        //-------------------------------------------------------------------------------//
        public bool setPortDirection(string port, string dData)
        {
            // Ensure correct case //
            port = port.ToUpper();     // Port Data upper case
            dData = dData.ToLower();   // Direction data lower case  

            // Write Data //
            string DIRData = "D" + port + dData;
                                   
            // Execute and return 
            return Write(DIRData);
        }
        //-------------------------------------------------------------------------------//


        //-------------------------------------------------------------------------------//
        public bool writePortData(string port, string pData)
        {
            // Ensure correct case //
            port = port.ToUpper();     // Port upper case
            pData = pData.ToLower();   // Data lower case  

            // Write Data //
            string writeData = "W" + port + pData;

            // Execute and return 
            return Write(writeData);
        }
        //-------------------------------------------------------------------------------//


        //-------------------------------------------------------------------------------//
        public bool writePortData32(string pData)
        {
            // Ensure correct case //
            pData = pData.ToLower();   // Direction data lower case  

            // Write Data //
            string writeData = "$" + "YY" + pData + "\r";

            // Execute and return 
            return Write(writeData);
        }
        //-------------------------------------------------------------------------------//

        
        //----------------------------------------------------------------------------//
        public bool readPortData(string port, out string rxData)
        {
            // Ensure correct case //
            port = port.ToUpper();     // Port upper case
            
            // Write Data //
            string dataStr = "$" + "R" + port + "\r";
                                  
            // Execute and return status and received data // 
            return Read(dataStr, out rxData);
           
        }
        //----------------------------------------------------------------------------//
        

        //*******************************************************************************//
        // Open USB Port
        //
        // Return value:
        //  0  = Success
        //  -1 = Unknown error.
        //  -2 = No un-opened JI-4040 devices found
        //
        // Updated: 3/10/2011
        //*******************************************************************************//
        public int Open()
        {
            // Determine the number of FTDI devices connected//

            ftStatus = FTDIDevice.GetNumberOfDevices(ref FTDIDeviceCount);
            // Verify command execution  //
            if (ftStatus != FTDI.FT_STATUS.FT_OK)
            {
                return -1; ;
            }

            // If no USB devices avialable, return //  
            if (FTDIDeviceCount == 0)
            {
                return -2;
            }

            // Allocate storage for device info list
            FTDI.FT_DEVICE_INFO_NODE[] FTDIDeviceList = new FTDI.FT_DEVICE_INFO_NODE[FTDIDeviceCount];

            // Populate device list
            ftStatus = FTDIDevice.GetDeviceList(FTDIDeviceList);
            // Verify command execution  //
            if (ftStatus != FTDI.FT_STATUS.FT_OK)
            {
                return -1; ;
            }
            
            // Find the first un-opened JI-4040 device and then open //
            string str1;
            for (uint i = 0; i < FTDIDeviceCount; ++i)
            {
                str1 = FTDIDeviceList[i].Description.ToString();
                // Check for JI-4040 device //
                if (str1.Contains("JI-4040") == true)
                {
                    // JI-4040 device found //
                    // Open device if it's un-opened //
                    if (0 == (int)(FTDIDeviceList[i].ftHandle))
                    {
                        str1 = FTDIDeviceList[i].SerialNumber;
                        ftStatus = FTDIDevice.OpenBySerialNumber(str1); // Open USB
                        if (ftStatus != FTDI.FT_STATUS.FT_OK)
                        {
                            // Error! //
                            return -1; ;
                        }
                        else
                        {
                            // Success, Port is open!!
                            return 0;
                        }
                    }
                
                }
            }

            // No un-opened JI-4040 devices found//
            return -2;
        }
        //*******************************************************************************//


        //*******************************************************************************//
        // Close USB Port
        //
        // Return value:
        //  0  = Success
        //  -1 = Error.
        //
        // Updated: 3/10/2011
        //*******************************************************************************//
        public int Close()
        {
            ftStatus = FTDIDevice.Close();
            if (ftStatus == FTDI.FT_STATUS.FT_OK)
            {
                return 0;  // Success: Port closed
            }
            else
            {
                return -1;  // Error
            }
        }
        //*******************************************************************************//


        //*******************************************************************************//
        // Initilize JI-4040
        //
        // Return value:
        //  True  = Success
        //  False = Error.
        // 
        // Updated: 3/10/2011
        //*******************************************************************************//
        public bool Init()
        {
            // Set BAUD rate to 1M //
            ftStatus = FTDIDevice.SetBaudRate(1000000);
            if (ftStatus == FTDI.FT_STATUS.FT_OK)
            {
                // Configure for 8-bit data, 2 stop bits, no parity //  
                FTDIDevice.SetDataCharacteristics(8, 2, 0);
                if (ftStatus == FTDI.FT_STATUS.FT_OK)
                {
                    return true;  // Success
                }
                return false;  // Error
            }
            else
            {
                return false;  // Error
            }
        }
        //*******************************************************************************//


        //*******************************************************************************//
        // General Purpose Write Command
        // 
        // 1. A "$" prefix and "\r" sufix are added to the command string.
        // 2. Returns a TRUE if command executes successfully
        //
        // New: 1/13/2011
        //*******************************************************************************//
        public bool Write(string str1)
        {
            // Write Data //
            string dataBuffer = "$" + str1 + "\r";
            uint numBytesWritten = 0;
            ftStatus = FTDIDevice.Write(dataBuffer, dataBuffer.Length, ref numBytesWritten);

            // Ensure successful USB Write //
            if (ftStatus != FTDI.FT_STATUS.FT_OK)
            {
                return false; // USB Error! //
            }

            uint numBytesRead = 0;
            uint RxQueue = 0;
            string rDataBuffer = "";

            // Wait for successful HW response "!" // 
            for (int loop = 0; loop < 100; ++loop)
            {
                Thread.Sleep(1);

                FTDIDevice.GetRxBytesAvailable(ref RxQueue);
                if (RxQueue > 0)
                {
                    ftStatus = FTDIDevice.Read(out rDataBuffer, RxQueue, ref numBytesRead);
                    if (ftStatus != FTDI.FT_STATUS.FT_OK)
                    {
                        return false; // USB Error! 
                    }
                    if (rDataBuffer.Contains('!'))
                    {
                        return true; // Done  
                    }
                    else if (rDataBuffer.Contains('?'))
                    {
                        return false; // HW Error! 
                    }
                }
               
            }
            return false; // Error! 
        }
        //*******************************************************************************//


        //*******************************************************************************//
        // Clear UART
        // 
        //
        // New: 2/7/2011
        //*******************************************************************************//
        public bool clrUART()
        {
            // Write Data //
            string dataBuffer = "\r";
            uint numBytesWritten = 0;
            
            ftStatus = FTDIDevice.Write(dataBuffer, dataBuffer.Length, ref numBytesWritten);

            // Ensure successful USB Write //
            if (ftStatus != FTDI.FT_STATUS.FT_OK)
            {
                return false; // USB Error! //
            }

            ftStatus = FTDIDevice.Write(dataBuffer, dataBuffer.Length, ref numBytesWritten);

            // Ensure successful USB Write //
            if (ftStatus != FTDI.FT_STATUS.FT_OK)
            {
                return false; // USB Error! //
            }

            uint numBytesRead = 0;
            uint RxQueue = 0;
            string rDataBuffer = "";

            // Clear Rx Buffer // 
            for (int loop = 0; loop < 100; ++loop)
            {
                Thread.Sleep(1);

                FTDIDevice.GetRxBytesAvailable(ref RxQueue);
                if (RxQueue > 0)
                {
                    ftStatus = FTDIDevice.Read(out rDataBuffer, RxQueue, ref numBytesRead);
                    if (ftStatus != FTDI.FT_STATUS.FT_OK)
                    {
                        return false; // USB Error! 
                    }
                 }
            }
            return true;  
        }
        //*******************************************************************************//





        //*******************************************************************************//
        // General Purpose Read Command
        // 
        // 1. A "$" prefix and "\r" sufix are added to the command string.
        // 2. A TRUE return indicates sucessful execution and that recDataStr is valid
        // 3. Received data returned via recDataStr
        //
        // New: 1/23/2011
        //*******************************************************************************//
        public bool Read(string CMDstr1, out string recDataStr)
        {
            recDataStr = "";
            
            // Write Command //
            string dataBuffer = "$" + CMDstr1 + "\r";
            uint numBytesWritten = 0;
            ftStatus = FTDIDevice.Write(dataBuffer, dataBuffer.Length, ref numBytesWritten);
            // Ensure successful USB Write //
            if (ftStatus != FTDI.FT_STATUS.FT_OK)
            {
               return false; // USB Error! //
            }

            uint numBytesRead = 0;
            uint RxQueue = 0;
            string rDataBuffer = "";
            
            // Read Response// 
        
            // Wait for successful HW response "!" // 
            for (int loop = 0; loop < 100; ++loop)
            {
                // Wait //
                Thread.Sleep(1);

                // Check Buffer for data //
                FTDIDevice.GetRxBytesAvailable(ref RxQueue);
                if (RxQueue > 0)
                {   
                    // Yes, data is avaliable // 
                    // Read Buffer// 
                    ftStatus = FTDIDevice.Read(out rDataBuffer, RxQueue, ref numBytesRead);
                    if (ftStatus != FTDI.FT_STATUS.FT_OK)
                    {
                        return false; // USB Error! 
                    }
                    else
                    {
                        recDataStr += rDataBuffer;
                    }

                    if (recDataStr.Contains('!'))
                    {
                        // Remove '!' mark //
                        recDataStr = recDataStr.TrimEnd('!');
                        return true; // Done  
                    }
                    else if (recDataStr.Contains('?'))
                    {
                       return false; // HW Error! 
                    }
                }
               
            }
            return false; // Error! 
        }
        //*******************************************************************************//


        //*******************************************************************************//
        // Write a single character
        // 
        //
        // New: 2/20/2011
        //*******************************************************************************//
        public bool writeOneChar(string str1)
        {
            // Write Data //
            string dataBuffer = str1;
            uint numBytesWritten = 0;

            ftStatus = FTDIDevice.Write(dataBuffer, dataBuffer.Length, ref numBytesWritten);

            // Ensure successful USB Write //
            if (ftStatus != FTDI.FT_STATUS.FT_OK)
            {
                return false; // USB Error! //
            }
            return true;
        }
        //*******************************************************************************//


        //*******************************************************************************//
        // Read USB Rx Buffer
        // 
        //
        // New: 2/20/2011
        //*******************************************************************************//
        public bool readUSBRx(out string recDataStr)
        {
            uint numBytesRead = 0;
            uint RxQueue = 0;
            string rDataBuffer = "";
            recDataStr = "";

            FTDIDevice.GetRxBytesAvailable(ref RxQueue);
            if (RxQueue > 0)
            {
                ftStatus = FTDIDevice.Read(out rDataBuffer, RxQueue, ref numBytesRead);
                if (ftStatus != FTDI.FT_STATUS.FT_OK)
                {
                    return false; // USB Error! 
                }
            }
            recDataStr = rDataBuffer;
            return true;
        }
        //*******************************************************************************//



    }
}
//***************************************************************************************//