﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using System.Threading;

using JI4516A_NET;


// **************************************************** //
// JI-4516 Control Application
//
// Intial Controlled Project Release: 8/22/2013
// Version: 8/22/2013
// 
// **************************************************** //


namespace JI_4516ControlApplication
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        // **************************************************** //
        //      Global variables                                //
        // **************************************************** //
                 
        public static string JI4516_HW_Ver = "?";
        public static string JI4516_FW_Ver = "?";
        
        //   //
        JI4516 JI4516_Device = new JI4516();

        bool deviceOpenFlg = false;



        /********************************************************/
        // 
        // Open USB
        //
        //****//
        private void USBopenButton_Click_1(object sender, EventArgs e)
        {
            // Open USB //
            if (JI4516_Device.Open() != 0)
            {
                USBstatusBox.Text = "Open failed!";
                statusTextBox.Text = "USB Open failed!";
                USBopenButton.Enabled = true;
                USBcloseButton.Enabled = false;
                inputGroupBox.Enabled = false;
                SWgroupBox.Enabled = false;
                configGroupBox.Enabled = false;
                deviceOpenFlg = false;
                stopWDTservice();
                WDTgroupBox.Enabled = false;

                JI4516_HW_Ver = "?";
                JI4516_FW_Ver = "?";

                return;
            }
            // Reset JI-4516 //
            JI4516_Device.Write("XX");

            USBstatusBox.Text = "Open";
            statusTextBox.Text = "USB Open";
            deviceOpenFlg = true;
            USBopenButton.Enabled = false;
            USBcloseButton.Enabled = true;
            inputGroupBox.Enabled = true;
            SWgroupBox.Enabled = true;
            WDTgroupBox.Enabled = true;
            configGroupBox.Enabled = true;

            updateSWHexBinData();

            // Read HW and FW Versions //
            readVersionMethod();
        }
        /****************************/


        /********************************************************/
        // 
        // Close USB
        //
        //****//
        private void USBcloseButton_Click_1(object sender, EventArgs e)
        {
            // Reset JI-4516 //
            JI4516_Device.Write("XX");

            // Close USB //
            JI4516_Device.Close();

            clrButtons();

            USBstatusBox.Text = "Closed";
            statusTextBox.Text = "USB Closed";
            deviceOpenFlg = false;
            USBopenButton.Enabled = true;
            USBcloseButton.Enabled = false;
            inputGroupBox.Enabled = false;
            configGroupBox.Enabled = false;
            SWgroupBox.Enabled = false;
            stopWDTservice();
            WDTgroupBox.Enabled = false;

            WDTtimeOutLabel.Visible = false;
            
            JI4516_HW_Ver = "?";
            JI4516_FW_Ver = "?";
        }
        /****************************/


        /********************************************************/
        //  Form Closing - Open switches and Close USB  
        //****//
        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            // Reset JI-4516 //
            JI4516_Device.Write("XX");

            // Close USB //
            JI4516_Device.Close();
        }
        /****************************/


        /***********************************************************/
        // Read Version Method
        //
        //**********************/
        private void readVersionMethod()
        {
            string str1 = "";
            if (JI4516_Device.Read("VV", out str1) == 0)
            {
                JI4516_HW_Ver = str1[0].ToString();
                JI4516_FW_Ver = str1[1].ToString();
            }
            else
            {
                JI4516_HW_Ver = "?";
                JI4516_FW_Ver = "?";
            }
        }
        /***********************************************************/


        
        /********************************************************/
        // Populate JI-4516 Configuration 
        //****//
        private void populateJI4516Config()
        {
            // Read Status Register //
            string recDataStr;
            if (JI4516_Device.Read("HR", out recDataStr) != 0)
            {
                //Error!!//
                statusTextBox.Text = "Error: Populate Config!"; 
                return;
            }

            int dataByteInt = System.Convert.ToInt32(recDataStr, 16);

            // WDT timer Enabled? //
            if ((dataByteInt & 0x80) == 0x80)
            {
                // Yes //
                WDTEnableCheckBox.Checked = true;
            }
            else
            {
                // No //
                WDTEnableCheckBox.Checked = false;
            }

            // WDT timer Time-Out? //
            if ((dataByteInt & 0x10) == 0x10)
            {
                // Yes //
                WDTtimeOutCheckBox.Checked = true;
                WDTtimeOutLabel.Visible = true;
                setButtonsSafePattern();
            }
            else
            {
                // No //
                WDTtimeOutCheckBox.Checked = false;
                WDTtimeOutLabel.Visible = false;
            }
            /*******/


            // Get WDT Time-Out time //
            if (JI4516_Device.Read("WR", out recDataStr) != 0)
            {
                statusTextBox.Text = "Error: WDT time-out!";
                return;
            }

            int j = Convert.ToUInt16(recDataStr, 16);
            decimal dec = Convert.ToDecimal(j);

            dec = dec / 10;
            currentTimeOutTextBox.Text = string.Format("{0:0.0}", dec);
            /*******/
              
            // Get Safe Pattern //
            if (JI4516_Device.Read("WG", out recDataStr) != 0)
            {
                statusTextBox.Text = "Error: Safe Pattern!";
                return;
            }

            currentOutputSafeHexTextBox.Text = recDataStr;
            int patternInt = Convert.ToUInt16(recDataStr, 16);
            string str2 = "";
            for (int i = 0; i < 8; ++i)
            {
                if ((patternInt & 0x01) == 0x01)
                    str2 = "1" + str2;
                else str2 = "0" + str2;

                if (i == 3)
                    str2 = " " + str2;

                patternInt = patternInt >> 1;
            }

            currentOutputSafeBinTextBox.Text = str2;
        }
        /****************************/




        bool sw8State_On = false;
        /********************************************************/
        // SW - 8
        //****//
        private void sw8Button_Click(object sender, EventArgs e)
        {
            if (sw8State_On)
            {
                // SW 8 Off //
                JI4516_Device.Write("SI" + "8" + "0");
                sw8Button.BackColor = Color.LightGray;
                sw8Button.Text = "0";
                sw8State_On = false;
            }
            else
            {
                // SW 8 On //
                JI4516_Device.Write("SI" + "8" + "1");
                sw8Button.BackColor = Color.Green;
                sw8Button.Text = "1";
                sw8State_On = true;
            }

            updateSWHexBinData();
        }
        /****************************/


        bool sw7State_On = false;
        /********************************************************/
        // SW - 7
        //****//
        private void sw7Button_Click_1(object sender, EventArgs e)
        {
            if (sw7State_On)
            {
                // SW 7 Off //
                JI4516_Device.Write("SI" + "7" + "0");
                sw7Button.BackColor = Color.LightGray;
                sw7Button.Text = "0";
                sw7State_On = false;
            }
            else
            {
                // SW 7 On //
                JI4516_Device.Write("SI" + "7" + "1");
                sw7Button.BackColor = Color.Green;
                sw7Button.Text = "1";
                sw7State_On = true;
            }

            updateSWHexBinData();
        }
        /****************************/


        bool sw6State_On = false;
        /********************************************************/
        // SW - 6
        //****//
        private void sw6Button_Click(object sender, EventArgs e)
        {
            if (sw6State_On)
            {
                // SW 6 Off //
                JI4516_Device.Write("SI" + "6" + "0");
                sw6Button.BackColor = Color.LightGray;
                sw6Button.Text = "0";
                sw6State_On = false;
            }
            else
            {
                // SW 7 On //
                JI4516_Device.Write("SI" + "6" + "1");
                sw6Button.BackColor = Color.Green;
                sw6Button.Text = "1";
                sw6State_On = true;
            }

            updateSWHexBinData();
        }
        /****************************/


        bool sw5State_On = false;
        /********************************************************/
        // SW - 5
        //****//
        private void sw5Button_Click(object sender, EventArgs e)
        {
            if (sw5State_On)
            {
                // SW 5 Off //
                JI4516_Device.Write("SI" + "5" + "0");
                sw5Button.BackColor = Color.LightGray;
                sw5Button.Text = "0";
                sw5State_On = false;
            }
            else
            {
                // SW 5 On //
                JI4516_Device.Write("SI" + "5" + "1");
                sw5Button.BackColor = Color.Green;
                sw5Button.Text = "1";
                sw5State_On = true;
            }

            updateSWHexBinData();
        }
        /****************************/


        bool sw4State_On = false;
        /********************************************************/
        // SW - 4
        //****//
        private void sw4Button_Click(object sender, EventArgs e)
        {
            if (sw4State_On)
            {
                // SW 4 Off //
                JI4516_Device.Write("SI" + "4" + "0");
                sw4Button.BackColor = Color.LightGray;
                sw4Button.Text = "0";
                sw4State_On = false;
            }
            else
            {
                // SW 4 On //
                JI4516_Device.Write("SI" + "4" + "1");
                sw4Button.BackColor = Color.Green;
                sw4Button.Text = "1";
                sw4State_On = true;
            }

            updateSWHexBinData();
        }
        /****************************/


        bool sw3State_On = false;
        /********************************************************/
        // SW - 3
        //****//
        private void sw3Button_Click(object sender, EventArgs e)
        {
            if (sw3State_On)
            {
                // SW 3 Off //
                JI4516_Device.Write("SI" + "3" + "0");
                sw3Button.BackColor = Color.LightGray;
                sw3Button.Text = "0";
                sw3State_On = false;
            }
            else
            {
                // SW 3 On //
                JI4516_Device.Write("SI" + "3" + "1");
                sw3Button.BackColor = Color.Green;
                sw3Button.Text = "1";
                sw3State_On = true;
            }

            updateSWHexBinData();
        }
        /****************************/


        bool sw2State_On = false;
        /********************************************************/
        // SW - 2
        //****//
        private void sw2Button_Click(object sender, EventArgs e)
        {
            if (sw2State_On)
            {
                // SW 2 Off //
                JI4516_Device.Write("SI" + "2" + "0");
                sw2Button.BackColor = Color.LightGray;
                sw2Button.Text = "0";
                sw2State_On = false;
            }
            else
            {
                // SW 2 On //
                JI4516_Device.Write("SI" + "2" + "1");
                sw2Button.BackColor = Color.Green;
                sw2Button.Text = "1";
                sw2State_On = true;
            }

            updateSWHexBinData();
        }
        /****************************/


        bool sw1State_On = false;
        /********************************************************/
        // SW - 1
        //****//
        private void sw1Button_Click(object sender, EventArgs e)
        {
            if (sw1State_On)
            {
                // SW 1 Off //
                JI4516_Device.Write("SI" + "1" + "0");
                sw1Button.BackColor = Color.LightGray;
                sw1Button.Text = "0";
                sw1State_On = false;
            }
            else
            {
                // SW 1 On //
                JI4516_Device.Write("SI" + "1" + "1");
                sw1Button.BackColor = Color.Green;
                sw1Button.Text = "1";
                sw1State_On = true;
            }

            updateSWHexBinData();
        }
        /****************************/




        /********************************************************/
        //  On, all switches  
        //****//
        private void onAllSwbutton_Click(object sender, EventArgs e)
        {
            JI4516_Device.Write("SWff");

            setButtons();
            updateSWHexBinData();
        }
        /********************************************************/

        /********************************************************/
        //  Off, all switches  
        //****//
        private void offAllSwbutton_Click(object sender, EventArgs e)
        {
            JI4516_Device.Write("SW00");

            clrButtons();
            updateSWHexBinData();
        }
        /****************************/

         /********************************************************/
        //  Read Input  
        //****//
        private void readInput()
        {
            // Read Input //
            string recDataStr;
            if (JI4516_Device.Read("IR", out recDataStr) != 0)
            {
                return;
            }
            
            // Display Hex value //
            inputHexTextBox.Text = recDataStr;

            // Display Bin value //
            int dataByteInt = System.Convert.ToInt32(recDataStr, 16);
            string str2 = "";
            for (int i = 0; i < 8; ++i)
            {
                if ((dataByteInt & 0x01) == 0x01)
                    str2 = "1" + str2;
                else str2 = "0" + str2;

                if (i == 3)
                    str2 = " " + str2;

                dataByteInt = dataByteInt >> 1;
            }
            inputBinTextBox.Text = str2;

            upDateInputDisplay(System.Convert.ToInt32(recDataStr, 16));


        }
        /****************************/

       


        /********************************************************/
        //  Clear Buttons  
        //****//
        private void clrButtons()
        {
            sw1Button.BackColor = Color.White;
            sw1Button.Text = "0";
            sw1State_On = false;

            sw2Button.BackColor = Color.White;
            sw2Button.Text = "0";
            sw2State_On = false;

            sw3Button.BackColor = Color.White;
            sw3Button.Text = "0";
            sw3State_On = false;

            sw4Button.BackColor = Color.White;
            sw4Button.Text = "0";
            sw4State_On = false;

            sw5Button.BackColor = Color.White;
            sw5Button.Text = "0";
            sw5State_On = false;

            sw6Button.BackColor = Color.White;
            sw6Button.Text = "0";
            sw6State_On = false;

            sw7Button.BackColor = Color.White;
            sw7Button.Text = "0";
            sw7State_On = false;

            sw8Button.BackColor = Color.White;
            sw8Button.Text = "0";
            sw8State_On = false;

            updateSWHexBinData();
        }
        /****************************/

        /********************************************************/
        //  Set Buttons  
        //****//
        private void setButtons()
        {
            sw1Button.BackColor = Color.Green;
            sw1Button.Text = "1";
            sw1State_On = true;

            sw2Button.BackColor = Color.Green;
            sw2Button.Text = "1";
            sw2State_On = true;

            sw3Button.BackColor = Color.Green;
            sw3Button.Text = "1";
            sw3State_On = true;

            sw4Button.BackColor = Color.Green;
            sw4Button.Text = "1";
            sw4State_On = true;

            sw5Button.BackColor = Color.Green;
            sw5Button.Text = "1";
            sw5State_On = true;

            sw6Button.BackColor = Color.Green;
            sw6Button.Text = "1";
            sw6State_On = true;

            sw7Button.BackColor = Color.Green;
            sw7Button.Text = "1";
            sw7State_On = true;

            sw8Button.BackColor = Color.Green;
            sw8Button.Text = "1";
            sw8State_On = true;

            updateSWHexBinData();
        }
        /****************************/

        
        /********************************************************/
        //  Set Buttons to Output Safe Pattern  
        //****//
        private void setButtonsSafePattern()
        {
            string recDataStr;

            // Get Safe Pattern //
            if (JI4516_Device.Read("WG", out recDataStr) != 0)
            {
                statusTextBox.Text = "Error: Safe Pattern!";
                return;
            }

            int patternInt = Convert.ToUInt16(recDataStr, 16);

            // Bit 1 //
            if ((patternInt & 0x01) == 0x01)
            {
                sw1Button.BackColor = Color.Green;
                sw1Button.Text = "1";
                sw1State_On = true;
            }
            else
            {
                sw1Button.BackColor = Color.White;
                sw1Button.Text = "0";
                sw1State_On = false;
            }

            // Bit 2 //
            if ((patternInt & 0x02) == 0x02)
            {
                sw2Button.BackColor = Color.Green;
                sw2Button.Text = "1";
                sw2State_On = true;
            }
            else
            {
                sw2Button.BackColor = Color.White;
                sw2Button.Text = "0";
                sw2State_On = false;
            }

            // Bit 3 //
            if ((patternInt & 0x04) == 0x04)
            {
                sw3Button.BackColor = Color.Green;
                sw3Button.Text = "1";
                sw3State_On = true;
            }
            else
            {
                sw3Button.BackColor = Color.White;
                sw3Button.Text = "0";
                sw3State_On = false;
            }

            // Bit 4 //
            if ((patternInt & 0x08) == 0x08)
            {
                sw4Button.BackColor = Color.Green;
                sw4Button.Text = "1";
                sw4State_On = true;
            }
            else
            {
                sw4Button.BackColor = Color.White;
                sw4Button.Text = "0";
                sw4State_On = false;
            }

            // Bit 5 //
            if ((patternInt & 0x10) == 0x10)
            {
                sw5Button.BackColor = Color.Green;
                sw5Button.Text = "1";
                sw5State_On = true;
            }
            else
            {
                sw5Button.BackColor = Color.White;
                sw5Button.Text = "0";
                sw5State_On = false;
            }

            // Bit 6 //
            if ((patternInt & 0x20) == 0x20)
            {
                sw6Button.BackColor = Color.Green;
                sw6Button.Text = "1";
                sw6State_On = true;
            }
            else
            {
                sw6Button.BackColor = Color.White;
                sw6Button.Text = "0";
                sw6State_On = false;
            }

            // Bit 7 //
            if ((patternInt & 0x40) == 0x40)
            {
                sw7Button.BackColor = Color.Green;
                sw7Button.Text = "1";
                sw7State_On = true;
            }
            else
            {
                sw7Button.BackColor = Color.White;
                sw7Button.Text = "0";
                sw7State_On = false;
            }

            // Bit 8 //
            if ((patternInt & 0x80) == 0x80)
            {
                sw8Button.BackColor = Color.Green;
                sw8Button.Text = "1";
                sw8State_On = true;
            }
            else
            {
                sw8Button.BackColor = Color.White;
                sw8Button.Text = "0";
                sw8State_On = false;
            }

            // Update Switch Display Data //
            updateSWHexBinData();
        }
        /****************************/


        /********************************************************/
        //  Update Switch Hex and Binary data displays  
        //****//
        private void updateSWHexBinData()
        {
            string binStr = "";
            int hexInt = 0;

            if (sw8Button.Text == "1")
            {
                binStr += "1";
                hexInt += 0x80;
            }
            else
            {
                binStr += "0";
                hexInt += 0x00;
            }

            if (sw7Button.Text == "1")
            {
                binStr += "1";
                hexInt += 0x40;
            }
            else
            {
                binStr += "0";
                hexInt += 0x00;
            }

            if (sw6Button.Text == "1")
            {
                binStr += "1";
                hexInt += 0x20;
            }
            else
            {
                binStr += "0";
                hexInt += 0x00;
            }

            if (sw5Button.Text == "1")
            {
                binStr += "1";
                hexInt += 0x10;
            }
            else
            {
                binStr += "0";
                hexInt += 0x00;
            }

            if (sw4Button.Text == "1")
            {
                binStr += " 1";
                hexInt += 0x08;
            }
            else
            {
                binStr += " 0";
                hexInt += 0x00;
            }

            if (sw3Button.Text == "1")
            {
                binStr += "1";
                hexInt += 0x04;
            }
            else
            {
                binStr += "0";
                hexInt += 0x00;
            }

            if (sw2Button.Text == "1")
            {
                binStr += "1";
                hexInt += 0x02;
            }
            else
            {
                binStr += "0";
                hexInt += 0x00;
            }

            if (sw1Button.Text == "1")
            {
                binStr += "1";
                hexInt += 0x01;
            }
            else
            {
                binStr += "0";
                hexInt += 0x00;
            }

            // Display Data //
            switchBinTextBox.Text = binStr;
            switchHexTextBox.Text = string.Format("{0:x2}", hexInt);
            
        }
        /****************************/


        /********************************************************/
        //  Update Input Display   
        //****//
        private void upDateInputDisplay(int dataByteInt)
        {
            // Bit 8 //
            if ((dataByteInt & 0x80) > 0)
            {
                IN8textBox.Text = "1";
                IN8textBox.BackColor = Color.Green;
            }
            else
            {
                IN8textBox.Text = "0";
                IN8textBox.BackColor = Color.White;
            }

            // Bit 7 //
            if ((dataByteInt & 0x40) > 0)
            {
                IN7textBox.Text = "1";
                IN7textBox.BackColor = Color.Green;
            }
            else
            {
                IN7textBox.Text = "0";
                IN7textBox.BackColor = Color.White;
            }

            // Bit 6 //
            if ((dataByteInt & 0x20) > 0)
            {
                IN6textBox.Text = "1";
                IN6textBox.BackColor = Color.Green;
            }
            else
            {
                IN6textBox.Text = "0";
                IN6textBox.BackColor = Color.White;
            }

            // Bit 5 //
            if ((dataByteInt & 0x10) > 0)
            {
                IN5textBox.Text = "1";
                IN5textBox.BackColor = Color.Green;
            }
            else
            {
                IN5textBox.Text = "0";
                IN5textBox.BackColor = Color.White;
            }

            // Bit 4 //
            if ((dataByteInt & 0x08) > 0)
            {
                IN4textBox.Text = "1";
                IN4textBox.BackColor = Color.Green;
            }
            else
            {
                IN4textBox.Text = "0";
                IN4textBox.BackColor = Color.White;
            }

            // Bit 3 //
            if ((dataByteInt & 0x04) > 0)
            {
                IN3textBox.Text = "1";
                IN3textBox.BackColor = Color.Green;
            }
            else
            {
                IN3textBox.Text = "0";
                IN3textBox.BackColor = Color.White;
            }

            // Bit 2 //
            if ((dataByteInt & 0x02) > 0)
            {
                IN2textBox.Text = "1";
                IN2textBox.BackColor = Color.Green;
            }
            else
            {
                IN2textBox.Text = "0";
                IN2textBox.BackColor = Color.White;
            }

            // Bit 1 //
            if ((dataByteInt & 0x01) > 0)
            {
                IN1textBox.Text = "1";
                IN1textBox.BackColor = Color.Green;
            }
            else
            {
                IN1textBox.Text = "0";
                IN1textBox.BackColor = Color.White;
            }
         
        }
        /****************************/



        /********************************************************/
        //  Get input   
        //****//
        private void getInputTimer_Tick(object sender, EventArgs e)
        {
            if (deviceOpenFlg == false)
            {
                return;
            }
            readInput();

            populateJI4516Config();
        }
        /****************************/



        /******************************************************************************/
        //                  WDT Service                                               //
        /******************************************************************************/
       
        /********************************************************/
        //  Start WDT Serice   
        //****//
        private void startWDTServiceButton_Click(object sender, EventArgs e)
        {
            // Send Start Sequence //
            WDT_StartSequenceMethod();

            // Start Servcie timer //
            WDTServiceTimer.Interval = (int)((WDTServPeriodUpDown.Value) *1000);
            WDTServiceTimer.Enabled = true;
            WDTServiceTimer.Start();
            statusTextBox.Text = "WDT Service Timer Running";

            startWDTServiceButton.Enabled = false;
            stopWDTServiceButton.Enabled = true;
            WDTServPeriodUpDown.Enabled = false;
           
        }
        /****************************/

        /********************************************************/
        //  Stop WDT Service   
        //****//
        private void stopWDTServiceButton_Click(object sender, EventArgs e)
        {
            stopWDTservice();
        }
        /****************************/

        /********************************************************/
        private void stopWDTservice()
        {
            WDTServiceTimer.Stop();
            WDTServiceTimer.Enabled = false;
            statusTextBox.Text = "Stopped";

            startWDTServiceButton.Enabled = true;
            stopWDTServiceButton.Enabled = false;
            WDTServPeriodUpDown.Enabled = true;
        }
        /****************************/

        /***********************************************************/
        // WDT Start Sequence Method
        //
        /**********************/
        private void WDT_StartSequenceMethod()
        {
            // Begin Sequence //
            if (JI4516_Device.Write("WS" + "53") != 0)
            {
                statusTextBox.Text = "Error: Start";
                return;
            }
            if (JI4516_Device.Write("WS" + "96") != 0)
            {
                statusTextBox.Text = "Error: Start";
                return;
            }
            if (JI4516_Device.Write("WS" + "12") != 0)
            {
                statusTextBox.Text = "Error: Start";
                return;
            }
            else
            {
                statusTextBox.Text = "OK: WDT Start Seq. ";
            }
        }
        /***********************************************************/
        

        /***********************************************************/
        // WDT Service Timer Tick
        //
        /**********************/
        private void WDTServiceTimer_Tick(object sender, EventArgs e)
        {
            if (JI4516_Device.Write("WT") != 0)
            {
                //Error!!//
                statusTextBox.Text = Text = "Error: WDT";
                
                // WDT Timer Stopped //
                WDTServiceTimer.Stop();
                WDTServiceTimer.Enabled = false;
            }

           // populateJI4516Config();
        }

        private void Form1_Load(object sender, EventArgs e)
        {

        }
        /***********************************************************/
        
        /******************************************************************************/
        //                                                                //
        /******************************************************************************/



        /******************************************************************************/
        private void userManualToolStripMenuItem_Click(object sender, EventArgs e)
        {

        }

        private void aboutToolStripMenuItem_Click(object sender, EventArgs e)
        {
            
            
            About messagePopUp = new About();
                        
            messagePopUp.ShowDialog();
        }
        /******************************************************************************/

        







    }
}
