﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using System.Threading;

//using JI4516A_NET;

namespace JI_4516_Test_Application2
{
    public partial class Form1 : Form
    {
        // Create a device object //
        JI4516A_NET.JI4516 DeviceA = new JI4516A_NET.JI4516();
        

        public Form1()
        {
            InitializeComponent();
        }

        /***********************************************************/
        // Open a Device
        //
        /**********************/
        private void uSBOpenButton_Click(object sender, EventArgs e)
        {
            if (DeviceA.Open() != 0)
            {
                statusTextBox.Text = "Error: USB Open";
            }
            else if (DeviceA.ClrUARTRx() != 0)
            {
                statusTextBox.Text = "Error: USB Clr";
            }
            else
            {
                statusTextBox.Text = "Open";
            }
        }
        /**********************/

        /**********************/
        private void uSBCloseButton_Click(object sender, EventArgs e)
        {
            int i = DeviceA.Close();
            if (i != 0)
            {
                statusTextBox.Text = "Error: USB Close";
            }
            else
            {
                statusTextBox.Text = "Closed";
            }
        }
        /***********************************************************/





        private void readInput_Button_Click(object sender, EventArgs e)
        {
            readInputMethod();
        }
       
        /***********************************************************/
        // Read Input Method
        //
        //**********************/
        private void readInputMethod()
        {
            string str1 = "";
            if (DeviceA.Read("IR", out str1) == 0)
            {
                readInputTextBox.Text = str1;
            }
            else
            {
                readInputTextBox.Text = "Error: Read";
            }
        }
        /***********************************************************/



        
        private void writeSwitches_Button_Click(object sender, EventArgs e)
        {
            writeSwitchesMethod();
        }
        
        /***********************************************************/
        // Write Switches Method
        //
        /**********************/
        private void writeSwitchesMethod()
        {
            if (DeviceA.Write("SW" + writeSwitchesDataTextBox.Text) == 0)
            {
                writeSwitchStatusTextBox.Text = "Ok: Write";
            }
            else
            {
                writeSwitchStatusTextBox.Text = "Error: Write";
            }
        }
        /***********************************************************/


        private void writeSwitchesInd_Button_Click(object sender, EventArgs e)
        {
            writeSwitchesIndMethod();
        }
        
        

        /***********************************************************/
        // Write Switches - Individual
        //
        /**********************/
        private void writeSwitchesIndMethod()
        {
            string str1 = (writeSwitchNumber.SelectedIndex + 1).ToString()
                          + writeSwitchState.SelectedIndex.ToString();

            if (DeviceA.Write("SI" + str1) == 0)
            {
                writeSwitchIndStatusTextBox.Text = "Ok: Write";
            }
            else
            {
                writeSwitchIndStatusTextBox.Text = "Error: Write";
            }
        }
        /***********************************************************/



        private void readSwitches_Button_Click(object sender, EventArgs e)
        {
            readSwitchesMethod();
        }
        
        /***********************************************************/
        // Read Output Switches Method
        //
        //**********************/
        private void readSwitchesMethod()
        {
            string str1 = "";
            if (DeviceA.Read("SR", out str1) == 0)
            {
                readSwitchesTextBox.Text = str1;
            }
            else
            {
                readSwitchesTextBox.Text = "Error: Read";
            }
        }
        /***********************************************************/


        private void writeConfigReg_Button_Click(object sender, EventArgs e)
        {
            writeConfigRegMethod();
        }

        /***********************************************************/
        // Write Configuration Register Method
        //
        /**********************/
        private void writeConfigRegMethod()
        {
            if (DeviceA.Write("CW" + writeConfigDataTextBox.Text) == 0)
            {
                writeConfigStatusTextBox.Text = "Ok: Write";
            }
            else
            {
                writeConfigStatusTextBox.Text = "Error: Write";
            }
        }
        /***********************************************************/


        private void readConfigReg_Button_Click(object sender, EventArgs e)
        {
            readConfigRegMethod();
        }
        
        /***********************************************************/
        // Read Configuration Register Method
        //
        //**********************/
        private void readConfigRegMethod()
        {
            string str1 = "";
            if (DeviceA.Read("CR", out str1) == 0)
            {
                readConfigRegTextBox.Text = str1;
            }
            else
            {
                readConfigRegTextBox.Text = "Error: Read";
            }
        }
        /***********************************************************/


        private void readStatusReg_Button_Click(object sender, EventArgs e)
        {
            readStatusRegMethod();
        }

        /***********************************************************/
        // Read Status Register Method
        //
        //**********************/
        private void readStatusRegMethod()
        {
            string str1 = "";
            if (DeviceA.Read("HR", out str1) == 0)
            {
                readStatusRegTextBox.Text = str1;
            }
            else
            {
                readStatusRegTextBox.Text = "Error: Read";
            }
        }
        /***********************************************************/


        private void enableCOS_Button_Click(object sender, EventArgs e)
        {
            enableCOSMethod();
        }

        /***********************************************************/
        // Enable COS Method
        //
        /**********************/
        private void enableCOSMethod()
        {
            if (DeviceA.WriteWO("KE") == 0)
            {
                enableCOS_TextBox.Text = "Ok: Enable";
            }
            else
            {
                enableCOS_TextBox.Text = "Error: Enable";
            }
        }
        /***********************************************************/


        private void disableCOS_Button_Click(object sender, EventArgs e)
        {
            disableCOSMethod();
        }
        
        /***********************************************************/
        // Disable COS Method
        //
        /**********************/
        private void disableCOSMethod()
        {
            if (DeviceA.WriteWO("KD") == 0) 
            {
                disableCOS_TextBox.Text = "Ok: Disable";
            }
            else
            {
                disableCOS_TextBox.Text = "Error: Disable";
            }
        }
        /***********************************************************/


        private void writeCOSMask_Button_Click(object sender, EventArgs e)
        {
            writeCOSMaskMethod();
        }
        
        /***********************************************************/
        // Write COS Mask Method
        //
        /**********************/
        private void writeCOSMaskMethod()
        {
            if (DeviceA.Write("MW" + writeCOSMaskDataTextBox.Text) == 0)
            {
                writeCOSMaskStatusTextBox.Text = "Ok: Write";
            }
            else
            {
                writeCOSMaskStatusTextBox.Text = "Error: Write";
            }
        }
        /***********************************************************/


        private void enableWDT_Button_Click(object sender, EventArgs e)
        {
            enableWDTMethod();
        }
        
        /***********************************************************/
        // Enable WDT Method
        //
        /**********************/
        private void enableWDTMethod()
        {
            if (DeviceA.Write("WE") == 0)
            {
                enableWDT_TextBox.Text = "Ok: Enable";
            }
            else
            {
                enableWDT_TextBox.Text = "Error: Enable";
            }
        }
        /***********************************************************/
        
        
        private void disableWDT_Button_Click(object sender, EventArgs e)
        {
            disableWDTMethod();
        }

        /***********************************************************/
        // Disable WDT Method
        //
        /**********************/
        private void disableWDTMethod()
        {
            if (DeviceA.Write("WD") == 0)
            {
                disableWDT_TextBox.Text = "Ok: Enable";
            }
            else
            {
                disableWDT_TextBox.Text = "Error: Enable";
            }
        }
        /***********************************************************/


        private void writeWDT_SSS_Button_Click(object sender, EventArgs e)
        {
            writeWDTSSSMethod();
        }

        /***********************************************************/
        // Write WDT Safe Switch State Method
        //
        /**********************/
        private void writeWDTSSSMethod()
        {
            if (DeviceA.Write("WF" + writeWDT_SSSDataTextBox.Text) == 0)
            {
                writeWDT_SSS_StatusTextBox.Text = "Ok: Write";
            }
            else
            {
                writeWDT_SSS_StatusTextBox.Text = "Error: Write";
            }
        }
        /***********************************************************/


        private void readWDT_SSS_Button_Click(object sender, EventArgs e)
        {
            readWDTSSSMethod();
        }

        /***********************************************************/
        // Read WDT Safe Switch State Method
        //
        //**********************/
        private void readWDTSSSMethod()
        {
            string str1 = "";
            if (DeviceA.Read("WG", out str1) == 0)
            {
                readWDT_SSS_DataTextBox.Text = str1;
            }
            else
            {
                readWDT_SSS_DataTextBox.Text = "Error: Read";
            }
        }
        /***********************************************************/


        private void writeWDT_TimeOut_Button_Click(object sender, EventArgs e)
        {
            writeWDT_TimeoutMethod();
        }


        /***********************************************************/
        // Write WDT Time-Out Period Method
        //
        /**********************/
        private void writeWDT_TimeoutMethod()
        {
            if (DeviceA.Write("WP" + writeWDT_TimeOut_DataTextBox.Text) == 0)
            {
                writeWDT_TimeOut_StatusTextBox.Text = "Ok: Write";
            }
            else
            {
                writeWDT_TimeOut_StatusTextBox.Text = "Error: Write";
            }
        }
        /***********************************************************/
        

        private void readWDT_TimeOut_Button_Click(object sender, EventArgs e)
        {
            readWDT_TimeoutMethod();
        }

        /***********************************************************/
        // Read WDT Time-Out Period Method
        //
        //**********************/
        private void readWDT_TimeoutMethod()
        {
            string str1 = "";
            if (DeviceA.Read("WR", out str1) == 0)
            {
                readWDT_TimeOut_DataTextBox.Text = str1;
            }
            else
            {
                readWDT_TimeOut_DataTextBox.Text = "Error: Read";
            }
        }
        /***********************************************************/


        private void readVersionRegButton_Click(object sender, EventArgs e)
        {
            readVersionMethod();
        }
        
        /***********************************************************/
        // Read Version Method
        //
        //**********************/
        private void readVersionMethod()
        {
            string str1 = "";
            if (DeviceA.Read("VV", out str1) == 0)
            {
                readVersionRegTextBox.Text = str1;
            }
            else
            {
                readVersionRegTextBox.Text = "Error: Read";
            }
        }
        /***********************************************************/


        private void resetJI4516Button_Click(object sender, EventArgs e)
        {
            resetJI4516Method();
        }

        /***********************************************************/
        // Reset JI-4516 Method
        //
        /**********************/
        private void resetJI4516Method()
        {
            if (DeviceA.Write("XX") == 0)
            {
                resetJI4516TextBox.Text = "Ok: Reset";
            }
            else
            {
                resetJI4516TextBox.Text = "Error: Reset";
            }
        }
        /***********************************************************/


        private void WDT_SaveSequenceButton_Click(object sender, EventArgs e)
        {
            WDT_SaveSequenceMethod();
        }

        /***********************************************************/
        // WDT Save Sequence Method
        //
        /**********************/
        private void WDT_SaveSequenceMethod()
        {
            // Begin Sequence //
            if (DeviceA.Write("WL" + "81") != 0)
            {
                WDT_SaveSequenceStatusTextBox.Text = "Error: Save";
                return;
            }
            if (DeviceA.Write("WL" + "16") != 0)
            {
                WDT_SaveSequenceStatusTextBox.Text = "Error: Save";
                return;
            }
            if (DeviceA.Write("WL" + "79") != 0)
            {
                WDT_SaveSequenceStatusTextBox.Text = "Error: Save";
                return;
            }

            // Delay 15 mS to allow for completion of EEPROM write cycle //
            Thread.Sleep(15);

            // Send Reset // 
            if (DeviceA.Write("XX") != 0)
            {
                WDT_SaveSequenceStatusTextBox.Text = "Error: Save";
            }
            else
            {
                WDT_SaveSequenceStatusTextBox.Text = "OK: Save";
            }
        }
        /***********************************************************/


        private void WDT_StartSequenceButton_Click(object sender, EventArgs e)
        {
            WDT_StartSequenceMethod();
        }

        /***********************************************************/
        // WDT Start Sequence Method
        //
        /**********************/
        private void WDT_StartSequenceMethod()
        {
            // Begin Sequence //
            if (DeviceA.Write("WS" + "53") != 0)
            {
                WDT_StartSequenceStatusTextBox.Text = "Error: Start";
                return;
            }
            if (DeviceA.Write("WS" + "96") != 0)
            {
                WDT_StartSequenceStatusTextBox.Text = "Error: Start";
                return;
            }
            if (DeviceA.Write("WS" + "12") != 0)
            {
                WDT_StartSequenceStatusTextBox.Text = "Error: Start";
                return;
            }
            else
            {
                WDT_StartSequenceStatusTextBox.Text = "OK: Start";
            }
        }
        /***********************************************************/


        /*************/
        // WDT Timer Service
        // 
        /***********************************************************/
        private void startWDT_ServiceButton_Click(object sender, EventArgs e)
        {
            WDT_ServiceTimer.Interval = Convert.ToUInt16(WDT_ServicePeriodTextBox.Text, 10);
            WDT_ServiceTimer.Enabled = true;
            WDT_ServiceTimer.Start();
            WDT_ServiceTextBox.Text = "Running";
        }

        private void stopWDT_ServiceButton_Click(object sender, EventArgs e)
        {
            WDT_ServiceTimer.Stop();
            WDT_ServiceTimer.Enabled = false;
            WDT_ServiceTextBox.Text = "Stopped";
        }

        private void WDT_ServiceTimer_Tick(object sender, EventArgs e)
        {
            if (DeviceA.Write("WT") != 0)
            {
                //Error!!//
                WDT_ServiceTextBox.Text = "Error: WDT";
            }
        }
        /***********************************************************/



        private void button1_Click(object sender, EventArgs e)
        {
            const int LOOP_CNT = 10000;
            int i = 0;

            int errorInt;

            while (i < LOOP_CNT)
            {
                // Set Port A output //
                string recDataStr;
                errorInt = DeviceA.Read("VV", out recDataStr);
                if (errorInt != 0)
                {
                    readVersionRegTextBox.Text = "Err!! " + i.ToString() + " " + errorInt.ToString();
                    i = LOOP_CNT;

                }
                else
                {
                    readVersionRegTextBox.Text = recDataStr + " " + i.ToString();
                }

                ++i;
            }

        }

        private void button2_Click(object sender, EventArgs e)
        {
            string recDataStr;
            int errorInt = DeviceA.ReadTest("VV", out recDataStr);

            readVersionRegTextBox.Text = errorInt.ToString() + " " + recDataStr ; 
        }
        /***********************************************************/

        





    }
}
