﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using JI820_Util_Class;
    
namespace JI820_SampleCode
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        JI820_USB_Class USB_JI820_IO = new JI820_USB_Class();


        //******************************************************//

        // Run Button //
        private void runButton_Click(object sender, EventArgs e)
        {
            int retValue = runCode();
            if (retValue == 0)
            {
                statusTextBox.Text = "Success: Encoder Running";
            }
        }

        // Stop Button //
        private void stopButton_Click(object sender, EventArgs e)
        {
            int retValue = stopCode();
            if (retValue == 0)
            {
                statusTextBox.Text = "Success: Encoder Stopped";
            }
        }

        //******************************************************//



        //******************************************************//
        //Run Code //
        private int runCode()
        {
            // If JI-820 connected to USB, Close port // 
            USB_JI820_IO.Close();
                  
            
            // Find JI-820 on USB port and Open // 
            if (USB_JI820_IO.Open() != 0)
            {
                statusTextBox.Text = "Error: Could not Open USB Port";
                return -1;
            }

            // Reset JI-820 Processes // 
            if (USB_JI820_IO.Write("ResetQuad") != 0)
            {
                statusTextBox.Text = "Error: ResetQuad CMD";
                return -1;
            }

            //*** Quadrature Configuration  **//

            // Set Phase and Phase Resolution //
            //  Set 90 degrees for all 4 phases and set reolution to 45 degrees  //
            if (USB_JI820_IO.Write("SetPhase 45 90 90 90 90") != 0)
            {
                statusTextBox.Text = "Error: SetPhase CMD";
                return -1;
            }
            
            // Set Cycles per Rev //
            //  CPR = 16 //
            if (USB_JI820_IO.Write("SetCyclesPerRev 16") != 0)
            {
                statusTextBox.Text = "Error: SetCyclesPerRev CMD";
                return -1;
            }

            // Set Cycles Time //
            //  Cycle Time = 1 ms //
            if (USB_JI820_IO.Write("SetCycleTimeMult 4994") != 0)
            {
                statusTextBox.Text = "Error: SetCycleTimeMult CMD";
                return -1;
            }

            // Set Quadrature Direction //
            //  Direction = Clock-Wise (CW)  //
            if (USB_JI820_IO.Write("SetQuadDirection 0") != 0)
            {
                statusTextBox.Text = "Error: SetQuadDirection CMD";
                return -1;
            }

            // Set Quadrature Mode //
            //  Mode = Free-Run  //
            if (USB_JI820_IO.Write("SetQuadMode 1") != 0)
            {
                statusTextBox.Text = "Error: SetQuadMode CMD";
                return -1;
            }

            // Set Z Signal Timing   //
            //           //
            if (USB_JI820_IO.Write("SetZModeTiming 3 45 270 90") != 0)
            {
                statusTextBox.Text = "Error: SetZModeTiming CMD";
                return -1;
            }

            // Set Z Signal Polarity   //
            //   signal Polarity = Positive   //
            if (USB_JI820_IO.Write("SetZPolarity 0") != 0)
            {
                statusTextBox.Text = "Error: SetZPolarity CMD";
                return -1;
            }
            
            // Enable Z Signal //
            //    //
            if (USB_JI820_IO.Write("EnableZ 1") != 0)
            {
                statusTextBox.Text = "Error: EnableZ CMD";
                return -1;
            }

            //** ************************ **//


            //*** Hardware Configuration  **//

            // Set Signal Voltage Source  //
            //  Voltage Source = Internal  //
            if (USB_JI820_IO.Write("SetVoltageSource 0") != 0)
            {
                statusTextBox.Text = "Error: SetVoltageSource CMD";
                return -1;
            }

            // Set Output Driver type   //
            //  Driver = Push-Pull  //
            if (USB_JI820_IO.Write("SetDriveType 0") != 0)
            {
                statusTextBox.Text = "Error: SetDriveType CMD";
                return -1;
            }

            // Sets Output Signal Voltage    //
            //  Signal Voltage = 5.00V  //
            if (USB_JI820_IO.Write("SetSigVoltage 5000") != 0)
            {
                statusTextBox.Text = "Error: SetSigVoltage CMD";
                return -1;
            }

            // Enable Encoder Signals    //
            //  Enable Signals  //
            if (USB_JI820_IO.Write("EnableSignals 1") != 0)
            {
                statusTextBox.Text = "Error: EnableSignals CMD";
                return -1;
            }

            //** ************************ **//


            //*** Run Command ***//

            // Run Encoder    //
            //  Run  //
            if (USB_JI820_IO.Write("Run 1") != 0)
            {
                statusTextBox.Text = "Error: Run CMD";
                return -1;
            }

            //** ************************ **//

            return 0;

        }

        //******************************************************//


        //******************************************************//
        //Stop Code //
        private int stopCode()
        {
            // Stop Encoder    //
            //  Stop  //
            if (USB_JI820_IO.Write("Run 0") != 0)
            {
                statusTextBox.Text = "Error: Run CMD";
                return -1;
            }

            // Disable Encoder Signals    //
            //  Disable Signals  //
            if (USB_JI820_IO.Write("EnableSignals 0") != 0)
            {
                statusTextBox.Text = "Error: EnableSignals CMD";
                return -1;
            }
            
            // Close USB Port // 
            if (USB_JI820_IO.Close() != 0)
            {
                statusTextBox.Text = "Error: Could not Close USB Port";
                return -1;
            }

            return 0;
        }
        //******************************************************//
            


    }
}
