﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Threading;
using FTD2XX_NET;


//*******************************************************************************//
// 3-12-2017 Status 
//
// Just statrted
// Class borrowed from JI640_USB_Netclass
//
//*******************************************************************************//
// _SampleCode
namespace JI820_Util_Class
{
    class JI820_USB_Class
    {

        // Create new instance of the FTDI device class
        FTDI FTDIDevice = new FTDI();

        UInt32 FTDIDeviceCount = 0;
        FTDI.FT_STATUS ftStatus = FTDI.FT_STATUS.FT_OK;



        //*******************************************************************************//
        // Open USB Port
        //
        // Find the first un-opened JI-4516 device, then open it. 
        //
        // Return value:
        //  0  = Success
        //  -1 = Unknown error.
        //  -2 = No JI-4516 devices found or devcies that were found are already open.
        //
        // Updated: 7/7/2015
        //*******************************************************************************//
        public int Open()
        {
            // Determine the number of FTDI devices connected//

            ftStatus = FTDIDevice.GetNumberOfDevices(ref FTDIDeviceCount);
            // Verify command execution  //
            if (ftStatus != FTDI.FT_STATUS.FT_OK)
            {
                return -1; ;
            }

            // If no USB devices avialable, return //  
            if (FTDIDeviceCount == 0)
            {
                return -2;
            }

            // Allocate storage for device info list
            FTDI.FT_DEVICE_INFO_NODE[] FTDIDeviceList = new FTDI.FT_DEVICE_INFO_NODE[FTDIDeviceCount];

            // Populate device list
            ftStatus = FTDIDevice.GetDeviceList(FTDIDeviceList);
            // Verify command execution  //
            if (ftStatus != FTDI.FT_STATUS.FT_OK)
            {
                return -1; ;
            }

            // Find the first un-opened JI-820 device and then open //
            string str1;
            for (uint i = 0; i < FTDIDeviceCount; ++i)
            {
                //Paul - handles the exception thrown when there is no device connected at the current element i
                try
                {
                    str1 = FTDIDeviceList[i].Description.ToString();
                }
                catch (Exception e)
                {
                    return -1;
                }

                // Check for JI-820 device //
                if (str1.Contains("JI-820") == true)
                {
                    // JI-820 device found //
                    // Open device if it's un-opened //
                    if (0 == (int)(FTDIDeviceList[i].ftHandle))
                    {
                        str1 = FTDIDeviceList[i].SerialNumber;
                        ftStatus = FTDIDevice.OpenBySerialNumber(str1); // Open USB
                        if (ftStatus != FTDI.FT_STATUS.FT_OK)
                        {
                            // Error! //
                            return -1; ;
                        }
                        else
                        {
                            // Success, Port is open!!
                            return 0;
                        }
                    }

                }
            }

            // No un-opened JI-820 devices found//
            return -2;
        }
        //*******************************************************************************//


        //*******************************************************************************//
        // Open By Serial Number
        //
        // Return value:
        //  0  = Success
        //  -1 = Unknown error.
        //  
        //
        // New: 4/14/2013
        //
        //*******************************************************************************//
        public int OpenBySerialNumber(string serialNumber)
        {
            // Determine the number of FTDI devices connected//

            ftStatus = FTDIDevice.GetNumberOfDevices(ref FTDIDeviceCount);
            // Verify command execution  //
            if (ftStatus != FTDI.FT_STATUS.FT_OK)
            {
                return -1; ;
            }

            // If no USB devices avialable, return //  
            if (FTDIDeviceCount == 0)
            {
                return -1;
            }

            // Open By Serial Number //
            ftStatus = FTDIDevice.OpenBySerialNumber(serialNumber);
            // Verify command execution  //
            if (ftStatus != FTDI.FT_STATUS.FT_OK)
            {
                return -1; ;
            }

            return 0;
        }
        //*******************************************************************************//



        //*******************************************************************************//
        // Get JI-820 Device Count, opened or un-opened
        //
        // Return value:
        //  0  = Success
        //  -1 = Error.
        //  
        //
        // Updated: 7/7/2015
        //*******************************************************************************//
        public int GetJI820DeviceCNT(out int deviceCount)
        //  public int GetJI4516DeviceCNT(ref int deviceCount)
        {
            deviceCount = 0;

            // Determine the number of FTDI devices connected//
            ftStatus = FTDIDevice.GetNumberOfDevices(ref FTDIDeviceCount);
            // Verify command execution  //
            if (ftStatus != FTDI.FT_STATUS.FT_OK)
            {
                return -1;
            }

            // If no USB devices avialable, return //  
            if (FTDIDeviceCount == 0)
            {
                return 0;
            }

            // Allocate storage for device list info
            FTDI.FT_DEVICE_INFO_NODE[] FTDIDeviceList = new FTDI.FT_DEVICE_INFO_NODE[FTDIDeviceCount];

            // Populate device list
            ftStatus = FTDIDevice.GetDeviceList(FTDIDeviceList);
            // Verify command execution  //
            if (ftStatus != FTDI.FT_STATUS.FT_OK)
            {
                return -1; ;
            }

            // Find all JI-820 devices opened or not //
            int JI640CNT = 0;
            string str1;
            for (uint i = 0; i < FTDIDeviceCount; ++i)
            {
                //Paul - handles the exception thrown when there is no device connected at the current element i
                try
                {
                    str1 = FTDIDeviceList[i].Description.ToString();
                }
                catch (Exception e)
                {
                    return -1;
                }

                // Check for JI-4516 device //
                if (str1.Contains("JI-820") == true)
                {
                    ++JI640CNT;
                }
            }

            // Return JI-4616 Count//
            deviceCount = JI640CNT;
            return 0;
        }
        //*******************************************************************************//


        //*******************************************************************************//
        // Get JI-820 Device Location
        //
        // Return value:
        //  0  = Success
        //  -1 = Error.
        //  
        //
        // Updated: 4/6/2013
        // Yes it works!
        //*******************************************************************************//
        public int GetJI820Location(out int USBLocation)
        //   public int getJI4516Location(ref int USBLocation)
        {
            USBLocation = 0;
            // Determine the number of FTDI devices connected//
            ftStatus = FTDIDevice.GetNumberOfDevices(ref FTDIDeviceCount);
            // Verify command execution  //
            if (ftStatus != FTDI.FT_STATUS.FT_OK)
            {
                return -1;
            }

            // If no USB devices avialable, return //  
            if (FTDIDeviceCount == 0)
            {
                return 0;
            }

            // Allocate storage for device list info
            FTDI.FT_DEVICE_INFO_NODE[] FTDIDeviceList = new FTDI.FT_DEVICE_INFO_NODE[FTDIDeviceCount];

            // Populate device list
            ftStatus = FTDIDevice.GetDeviceList(FTDIDeviceList);
            // Verify command execution  //
            if (ftStatus != FTDI.FT_STATUS.FT_OK)
            {
                return -1;
            }

            // Find the first un-opened JI-4516 device and then open //
            int location = 0;
            int bitLocation = 1;
            string str1;
            for (int i = 0; i < FTDIDeviceCount; ++i)
            {
                str1 = FTDIDeviceList[i].Description.ToString();
                // Check for JI-4516 device //
                if (str1.Contains("JI-820") == true)
                {
                    location |= bitLocation;
                }

                bitLocation = bitLocation << 1;
            }

            USBLocation = location;
            return 0;
        }
        //*******************************************************************************//



        //*******************************************************************************//
        // Get JI-820 Device SN via device location
        //
        // Return value:
        //  0  = Success
        //  -1 = Error.
        //  
        //
        // Updated: 4/6/2013
        //*******************************************************************************//
        public int GetJI820DeviceSerialNumber(int deviceNumber, out string serialNumber)
        // public int getJI4516DeviceSerialNumber(int deviceNumber, ref string serialNumber)
        {
            serialNumber = "";

            // Determine the number of FTDI devices connected//
            ftStatus = FTDIDevice.GetNumberOfDevices(ref FTDIDeviceCount);
            // Verify command execution  //
            if (ftStatus != FTDI.FT_STATUS.FT_OK)
            {
                return -1;
            }

            // If no USB devices are avialable or deviceNumber is > FTDIDeviceCount, return//  
            if (FTDIDeviceCount == 0 || deviceNumber > FTDIDeviceCount)
            {
                return -1;
            }

            // Allocate storage for device info list
            FTDI.FT_DEVICE_INFO_NODE[] FTDIDeviceList = new FTDI.FT_DEVICE_INFO_NODE[FTDIDeviceCount];

            // Populate device list
            ftStatus = FTDIDevice.GetDeviceList(FTDIDeviceList);
            // Verify command execution  //
            if (ftStatus != FTDI.FT_STATUS.FT_OK)
            {
                return -1;
            }

            string str1 = FTDIDeviceList[deviceNumber].Description.ToString();

            // Verify this is a JI-4516 device //
            if (str1.Contains("JI-820") != true)
            {
                return -1;
            }

            // Get Serial Number of Device //
            if (0 == (int)(FTDIDeviceList[deviceNumber].ftHandle))
            {
                serialNumber = FTDIDeviceList[deviceNumber].SerialNumber.ToString();
                return 0;
            }
            else
            {
                return -1;
            }

        }
        //*******************************************************************************//

        //*******************************************************************************//
        // Get count of unopened JI-820 Device Count and serial numbers
        //
        // Return value:
        //  0  = Success
        //  -1 = Error.
        //  
        //
        // Updated: 7/8/2015
        //*******************************************************************************//
        public int GetJI820DeviceCNTandSerialNumbers(out int deviceCount, out string[] deviceSN)
        //  public int GetJI4516DeviceCNT(ref int deviceCount)
        {
            deviceCount = 0;

            deviceSN = new string[6];   // definite assignment of deviceSN

            // deviceSN[0] = "eRIK";


            // Determine the number of FTDI devices connected//
            ftStatus = FTDIDevice.GetNumberOfDevices(ref FTDIDeviceCount);
            // Verify command execution  //
            if (ftStatus != FTDI.FT_STATUS.FT_OK)
            {
                return -1;
            }

            // If no USB devices avialable, return //  
            if (FTDIDeviceCount == 0)
            {
                return 0;
            }

            // Allocate storage for device list info
            FTDI.FT_DEVICE_INFO_NODE[] FTDIDeviceList = new FTDI.FT_DEVICE_INFO_NODE[FTDIDeviceCount];

            // Populate device list
            ftStatus = FTDIDevice.GetDeviceList(FTDIDeviceList);
            // Verify command execution  //
            if (ftStatus != FTDI.FT_STATUS.FT_OK)
            {
                return -1; ;
            }

            // Find all JI-820 devices opened or not //
            int JI640CNT = 0;
            string str1;
            for (uint i = 0; i < FTDIDeviceCount; ++i)
            {
                //Paul - handles the exception thrown when there is no device connected at the current element i
                try
                {
                    str1 = FTDIDeviceList[i].Description.ToString();
                }
                catch (Exception e)
                {
                    return -1;
                }

                // Check for JI-820 device //
                if (str1.Contains("JI-820") == true)
                {
                    ++JI640CNT;
                }
            }

            // Return JI-4616 Count//
            deviceCount = JI640CNT;
            return 0;
        }
        //*******************************************************************************//


        //*******************************************************************************//
        // Close USB Port
        //
        //
        // Return value:
        //  0  = Success
        //  -1 = Error.
        //
        // Updated: 10/5/2012
        //*******************************************************************************//
        public int Close()
        {
            ftStatus = FTDIDevice.Close();
            if (ftStatus == FTDI.FT_STATUS.FT_OK)
            {
                return 0;  // Success: Port closed
            }
            else
            {
                return -1;  // Error
            }
        }
        //*******************************************************************************//


        //*******************************************************************************//
        // Read USB Rx Buffer
        // 
        // Return value:
        //  True  = Success
        //  False = Error, USB
        //
        // Updated: 10/5/2012
        //*******************************************************************************//
        private bool readUSBRx(out string recDataStr)
        {
            uint numBytesRead = 0;
            uint RxQueue = 0;
            string rDataBuffer = "";
            recDataStr = "";

            FTDIDevice.GetRxBytesAvailable(ref RxQueue);
            if (RxQueue > 0)
            {
                ftStatus = FTDIDevice.Read(out rDataBuffer, RxQueue, ref numBytesRead);
                if (ftStatus != FTDI.FT_STATUS.FT_OK)
                {
                    return false; // USB Error! 
                }
            }
            recDataStr = rDataBuffer;
            return true;
        }
        //*******************************************************************************//

        //*******************************************************************************//
        // Used for USB development testing //
        //
        private bool writeUSBtest(string str1)
        {
            // Write Data //
            string dataBuffer = "$" + str1 + "\r";
            uint numBytesWritten = 0;
            ftStatus = FTDIDevice.Write(dataBuffer, dataBuffer.Length, ref numBytesWritten);

            // Ensure successful USB Write //
            if (ftStatus != FTDI.FT_STATUS.FT_OK)
            {
                return false; // USB Error! //
            }
            return true;
        }
        //*******************************************************************************//


        //*******************************************************************************//
        // General Purpose Write Command
        // 
        // 1. A "$" prefix and "\r" sufix are added to the command string.
        // 2. Returns a TRUE if command executes successfully. False is false problem occured
        //
        // Return value:
        //  0  = Success
        //  -1 = Error - USB
        //  -2 = Error - HW
        //  -3 = Error - time-out
        //
        // New: 1/13/2011
        // Updated: 10/2012 
        //*******************************************************************************//
        public int Write(string str1)
        {
            // Write Data //
            //string dataBuffer = "$" + str1 + "\r";
            string dataBuffer = str1 + "\r";
            uint numBytesWritten = 0;
            ftStatus = FTDIDevice.Write(dataBuffer, dataBuffer.Length, ref numBytesWritten);

            // Ensure successful USB Write //
            if (ftStatus != FTDI.FT_STATUS.FT_OK)
            {
                return -1; // USB Error! //
            }

            uint numBytesRead = 0;
            uint RxQueue = 0;
            string rDataBuffer = "";

            // Wait for successful HW response "!" // 
            for (int loop = 0; loop < 100; ++loop)
            {
                Thread.Sleep(1);

                FTDIDevice.GetRxBytesAvailable(ref RxQueue);
                if (RxQueue > 0)
                {
                    ftStatus = FTDIDevice.Read(out rDataBuffer, RxQueue, ref numBytesRead);
                    if (ftStatus != FTDI.FT_STATUS.FT_OK)
                    {
                        return -1; // USB Error! 
                    }
                    if (rDataBuffer.Contains('!'))
                    {
                        return 0; // Done  
                    }
                    else if (rDataBuffer.Contains('?'))
                    {
                        return -2; // HW Error! 
                    }
                }

            }
            return -3; // time-out Error! 
        }
        //*******************************************************************************//

        //*******************************************************************************//
        // Write Command W/O Response
        // 
        // 1. A "$" prefix and "\r" sufix are added to the command string.
        // 2. Returns a TRUE if command executes successfully. False is false problem occured.
        // 3. Command does not look for valid response character '!'
        //
        // Return value:
        //  0  = Success
        //  -1 = Error.
        //
        // New: 4/1/2013

        //*******************************************************************************//
        public int WriteWO(string str1)
        {
            // Write Data //
            string dataBuffer = "$" + str1 + "\r";
            uint numBytesWritten = 0;
            ftStatus = FTDIDevice.Write(dataBuffer, dataBuffer.Length, ref numBytesWritten);

            // Ensure successful USB Write //
            if (ftStatus != FTDI.FT_STATUS.FT_OK)
            {
                return -1; // USB Error! //
            }
            else
            {
                return 0;
            }

        }
        //*******************************************************************************//


        //*******************************************************************************//
        // General Purpose Read Command
        // 
        // 1. A "$" prefix and "\r" sufix are added to the command string.
        // 2. A TRUE return indicates sucessful execution and that recDataStr is valid
        // 3. Received data returned via recDataStr
        //
        // Return value:
        //  0  = Success
        //  -1 = USB Error #1.
        //  -2 = USB Error #2
        //  -3 = HW Error
        //  -4 = ? Error
        //
        // New: Modified for JI-820 on 8/21/2015
        //*******************************************************************************//
        public int Read(string CMDstr1, out string recDataStr)
        {
            recDataStr = "";

            // Write Command //
            //string dataBuffer = "$" + CMDstr1 + "\r";
            string dataBuffer = CMDstr1 + "\r";
            uint numBytesWritten = 0;
            ftStatus = FTDIDevice.Write(dataBuffer, dataBuffer.Length, ref numBytesWritten);
            // Ensure successful USB Write //
            if (ftStatus != FTDI.FT_STATUS.FT_OK)
            {
                return -1; // USB Error! //
            }

            uint numBytesRead = 0;
            uint RxQueue = 0;
            string rDataBuffer = "";

            // Read Response// 

            // Wait for successful HW response "!" // 
            for (int loop = 0; loop < 100; ++loop)
            {
                // Wait //
                Thread.Sleep(1);

                // Check Buffer for data //
                FTDIDevice.GetRxBytesAvailable(ref RxQueue);
                if (RxQueue > 0)
                {
                    // Yes, data is avaliable // 
                    // Read Buffer// 
                    ftStatus = FTDIDevice.Read(out rDataBuffer, RxQueue, ref numBytesRead);
                    if (ftStatus != FTDI.FT_STATUS.FT_OK)
                    {
                        return -2; // USB Error! 
                    }
                    else
                    {
                        recDataStr += rDataBuffer;
                    }

                    if (recDataStr.Contains('!'))
                    {
                        // Remove '!' mark //
                        recDataStr = recDataStr.TrimEnd('!');
                        return 0; // Done  
                    }
                    else if (recDataStr.Contains('?'))
                    {
                        return -3; // HW Error! 
                    }
                }

            }
            return -4; // Error! 
        }
        //*******************************************************************************//

        //*******************************************************************************//
        // Read Test Command
        // 
        // 1. Returns all contents of receive buffer prior to a '!'. 
        //
        // Return value:
        //  0  = Success
        //  -1 = USB Error #1.
        //  -2 = USB Error #2
        //  -4 = ? Error
        //
        // New: 4/26/2013
        //*******************************************************************************//
        public int ReadTest(string CMDstr1, out string recDataStr)
        {
            recDataStr = "";

            // Write Command //
            string dataBuffer = "$" + CMDstr1 + "\r";
            uint numBytesWritten = 0;
            ftStatus = FTDIDevice.Write(dataBuffer, dataBuffer.Length, ref numBytesWritten);
            // Ensure successful USB Write //
            if (ftStatus != FTDI.FT_STATUS.FT_OK)
            {
                return -1; // USB Error! //
            }

            uint numBytesRead = 0;
            uint RxQueue = 0;
            string rDataBuffer = "";

            // Read Response// 

            // Wait for successful HW response "!" // 
            for (int loop = 0; loop < 100; ++loop)
            {
                // Wait //
                Thread.Sleep(1);

                // Check Buffer for data //
                FTDIDevice.GetRxBytesAvailable(ref RxQueue);
                if (RxQueue > 0)
                {
                    // Yes, data is avaliable // 
                    // Read Buffer// 
                    ftStatus = FTDIDevice.Read(out rDataBuffer, RxQueue, ref numBytesRead);
                    if (ftStatus != FTDI.FT_STATUS.FT_OK)
                    {
                        return -2; // USB Error! 
                    }
                    else
                    {
                        recDataStr += rDataBuffer;
                    }

                    if (recDataStr.Contains('!'))
                    {
                        // Remove '!' mark //
                        //    recDataStr = recDataStr.TrimEnd('!');
                        return 0; // Done  
                    }
                    //  else if (recDataStr.Contains('?'))
                    //  {
                    //      return -3; // HW Error! 
                    //  }
                    else if (recDataStr.Contains('?'))
                    {
                        return -3; // HW Error! 
                    }
                }

            }
            return -4; // Error! 
        }
        //*******************************************************************************//


        //*******************************************************************************//
        // Clear UART
        //
        // Return value:
        //  0  = Success
        //  -1 = Error. 
        //
        // New: 2/7/2011
        //*******************************************************************************//
        public int ClrUARTRx()
        {
            // Write Data //
            string dataBuffer = "\r";
            uint numBytesWritten = 0;

            ftStatus = FTDIDevice.Write(dataBuffer, dataBuffer.Length, ref numBytesWritten);

            // Ensure successful USB Write //
            if (ftStatus != FTDI.FT_STATUS.FT_OK)
            {
                return -1; // USB Error! //
            }

            ftStatus = FTDIDevice.Write(dataBuffer, dataBuffer.Length, ref numBytesWritten);

            // Ensure successful USB Write //
            if (ftStatus != FTDI.FT_STATUS.FT_OK)
            {
                return -1; // USB Error! //
            }

            uint numBytesRead = 0;
            uint RxQueue = 0;
            string rDataBuffer = "";

            // Clear Rx Buffer // 
            for (int loop = 0; loop < 100; ++loop)
            {
                Thread.Sleep(1);

                FTDIDevice.GetRxBytesAvailable(ref RxQueue);
                if (RxQueue > 0)
                {
                    ftStatus = FTDIDevice.Read(out rDataBuffer, RxQueue, ref numBytesRead);
                    if (ftStatus != FTDI.FT_STATUS.FT_OK)
                    {
                        return -1; // USB Error! 
                    }
                }
            }
            return 0;
        }
        //*******************************************************************************//














    }
}
